package com.example.sefinsa_app.ui.clientes.fotos;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;

import com.example.sefinsa_app.R;

import java.util.ArrayList;
import java.util.List;

import okhttp3.MultipartBody;

public class ClientesFotosDialogFragment extends DialogFragment implements ClientesFotosFragment.OnPhotosSelectedListener {

    private OnDialogDismissedListener listener;

    public interface OnDialogDismissedListener {
        void onDialogDismissed(Bundle bundle); // Método para enviar datos al fragmento o actividad
    }
    @Override
    public void onPhotosSelected(ArrayList<String> pathsComprobantesCliente,
                                 ArrayList<String> pathsGarantiasCliente,
                                 ArrayList<String> pathsIneCliente,
                                 ArrayList<String> pathsFotoCliente,
                                 ArrayList<String> pathsContratoCliente,
                                 ArrayList<String> pathsFachadaCliente,
                                 List<MultipartBody.Part>archivosGeneral) {

        Fragment parentFragment = getParentFragment();
        if (parentFragment instanceof ClientesFotosFragment.OnPhotosSelectedListener) {
            ((ClientesFotosFragment.OnPhotosSelectedListener) parentFragment).onPhotosSelected(
                    pathsComprobantesCliente, pathsGarantiasCliente, pathsIneCliente, pathsFotoCliente, pathsContratoCliente, pathsFachadaCliente, archivosGeneral);
        }
        dismiss();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_dialog_container, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        ClientesFotosFragment clientesFotosFragment = new ClientesFotosFragment();

        // Verificar si tenemos argumentos y si el tipo es "2"
        if (getArguments() != null) {
            String tipo = getArguments().getString("tipo");

            // Si tipo es "2", pasar los datos al fragmento
            if ("2".equals(tipo)) {
                String clienteJson = getArguments().getString("cliente");
                String clienteId = getArguments().getString("clienteId");

                Log.d("ClientesFotosDialog", "Recibido tipo: " + tipo);
                Log.d("ClientesFotosDialog", "JSON de cliente: " + clienteJson);
                Log.d("ClientesFotosDialog", "ID de cliente: " + clienteId);

                Bundle bundle = new Bundle();
                bundle.putString("cliente", clienteJson);
                bundle.putString("clienteId", clienteId);

                clientesFotosFragment.setArguments(bundle);

            } else {
                Log.d("ClientesFotosDialog", "Cargando vista normal, sin datos");
            }
        } else {
            Log.d("ClientesFotosDialog", "No se recibieron argumentos.");
        }

        getChildFragmentManager().beginTransaction()
                .replace(R.id.dialog_fragment_container, clientesFotosFragment)
                .commit();

        // Configurar el botón para cerrar el diálogo
        Button closeButton = view.findViewById(R.id.close_buttonF);
        closeButton.setOnClickListener(v -> dismiss());
    }

    @Override
    public void onStart() {
        super.onStart();
        if (getDialog() != null) {
            getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        }
    }
}
